#ifndef FX_FLUIDSIM_H
#define FX_FLUIDSIM_H

enum
{

	FLUIDSIM_DEBUG_VOL = 8000,
		FLUIDSIM_DEBUG_VOL_UVOL = 0,
		FLUIDSIM_DEBUG_VOL_VVOL,
		FLUIDSIM_DEBUG_VOL_WVOL,
		FLUIDSIM_DEBUG_VOL_T12VOL,
		FLUIDSIM_DEBUG_VOL_T13VOL,
		FLUIDSIM_DEBUG_VOL_T23VOL,
		FLUIDSIM_DEBUG_VOL_CVOL,

	//TABS
	ID_FLUID_G = 2000,
	ID_ADVANCED,
	ID_FLUIDPARTICLES_G,
	ID_TEMPERATURE,
	ID_DENSITY_G,
	ID_FUEL_G,
	ID_GLOBAL,
	ID_VORTICITY_G,
	ID_SLAVES_G,
	ID_SIMPLEPARTICLES_G,
	ID_THINKINGPARTICLES_G,
	ID_FLOW_G,
	ID_COLOR_G,
	ID_BASICS_G,
	ID_FIRE_G,
	FlUIDSIM_GMEMORY_G,
	FLUIDSIM_PRESETS_G,
	ID_MEDIA_G,
	ID_PARTICLES_G,
	ID_SIMULATION_FX_G,
	ID_FLUIDCACHE_SID,
	ID_SMOKECACHE_SID,
	ID_TEMPCACHE_SID,
	ID_FUELCACHE_SID,
	ID_FIRECACHE_SID,
	ID_COLORCACHE_SID,
	ID_FLOWMAPCACHE_SID,
	ID_SPRAYPARTICLES_G,
	FLUIDSIM_SPRAY_EMISSION_SID,
	FLUIDSIM_SPRAY_LIFE_SID,
	ID_FOAMPARTICLES_G,
	ID_BUBBLEPARTICLES_G,
	ID_DISPLAY_G,
	ID_FPCACHE_SID,

	//SUBGROUPS
	ID_SIMPLEPARTICLES_S_EMISSION = 3000,
	ID_SIMPLEPARTICLES_S_CONVERSIONTOFP,
	FLUIDSIM_S_VORTEXEMISSION,
	SUB_FLUID_AND_DPIT_SPTOFP,
	FLUIDSIM_CACHERENDER_SID,
	FLUIDSIM_CACHEEDITOR_SID,
	FLUIDSIM_ADVANCED_SID,
	FLUIDSIM_SEP_GLOBALDOMAIN,
	FLUIDSIM_SEP_GLOBALSIMULATION,
	ID_BUOYANCY_SID,
	ID_EXTERNAL_SID,
	ID_SMOKETARGET_SID,
	FlUIDSIM_SUBDIVISION_SID,
	FLUIDSIM_SUBTURBULENCE,
	FlUIDSIM_BOUNDARY_SID,
	SID_FLUIDSIM_SOLVERDETAILS,
	FLUIDSIM_STARTGRID_SID,
	FLUIDSIM_S_VORTEXEMISSIONSP,
	FLUIDSIM_S_VORTEXEMISSIONTP,
	ID_FLUIDPARTICLES_SID_MEDIA,
	ID_FLUIDPARTICLES_SID_WIND,
	ID_FLUIDPARTICLES_SID_SP,
	ID_SIMPLEPARTICLES_S_EMISSIONWIND,
	ID_THINKINGPARTICLES_S_EMISSION,
	ID_THINKINGPARTICLES_S_EMISSIONWIND,
	FLUIDSIM_SID_MEDIACHANNELS,
	FLUIDSIM_SID_CUSTOMCHANNELS,
	FLUIDSIM_VORTICITY_PARTICLES_SID,
	FlUIDSIM_SUBDIVISION_L1_SID,
	FlUIDSIM_SUBDIVISION_L2_SID,
	FlUIDSIM_SUBDIVISION_L3_SID,
	FlUIDSIM_SUBDIVISION_L4_SID,
	FLUIDSIM_CACHE_CHANNELS_SID,
	FLUIDSIM_FSSMIXER,
	FLUIDSIM_SIMMIXER,
	FLUIDSIM_COMBUSTION_SEP,

	//GLOBAL TAB
	FLUIDSIM_CHANNEL_FIRE = 1000,
	FLUIDSIM_CHANNEL_SMOKE,
	FLUIDSIM_CHANNEL_FUEL,
	FLUIDSIM_CHANNEL_HEAT,
	FLUIDSIM_CHANNEL_TEX,	
	FLUIDSIM_SHOWINFO,
	FLUIDSIM_GRIDCELLS,
	FLUIDSIM_GRIDCELLS_RENDER,
	FLUIDSIM_GRIDSIZE,
	FLUIDSIM_BRD_LEFT,
	FLUIDSIM_BRD_RIGHT,
	FLUIDSIM_BRD_BOTTOM,
	FLUIDSIM_BRD_TOP,
	FLUIDSIM_BRD_FRONT,
	FLUIDSIM_BRD_BACK,		
	FLUIDSIM_USESCENESTEP = 1015,
	FLUIDSIM_USESCENESTEP_AUTO = 0,
	FLUIDSIM_USESCENESTEP_AUTOFRAME,
	FLUIDSIM_USESCENESTEP_CUSTOM,
	FLUIDSIM_TIMESTEP = 1016,
	FLUIDSIM_AUTOTIME,
	FLUIDSIM_FROM,
	FLUIDSIM_TO,

	//SLAVES TAB
	FLUIDSIM_ADDFLUIDOBJECT = 1020,
	FLUIDSIM_OBJECTLIST,
	FLUIDSIM_C4DFORCELIST,

	//VORTICITY TAB
	FLUIDSIM_USEVORTEX = 1023,
	FLUIDSIM_VORTICITY_GLOBAL = 0,
	FLUIDSIM_VORTICITY_LOCAL,
	FLUIDSIM_VORTICITY_GRADIENT,
	FLUIDSIM_VORTICITY_VORTEX,
	FLUIDSIM_VORTICITY = 1024,
	FLUIDSIM_VORTICITY_RADIUS = 1025,

	//FLUID AIR TAB
	FLUIDSIM_VISCOSITY = 1026,
	FLUIDSIM_ALGO = 1027,
	FLUIDSIM_ALGO_LINEAR = 0,
	FLUIDSIM_ALGO_COSINE,
	FLUIDSIM_ALGO_HERMITE,
	FLUIDSIM_TRACEALGO = 1028,
	FLUIDSIM_TRACEALGO_EULER1ST = 0,
	FLUIDSIM_TRACEALGO_RUNGA2ND,
	FLUIDSIM_TRACEALGO_RUNGA3RD,
	FLUIDSIM_TRACEALGO_RUNGA4TH,
	FLUIDSIM_MAXITERATIONS = 1029,

	//SMOKE TAB
	FLUIDSIM_DIFFUSION = 1030,
	FLUIDSIM_DISSIPATION,
	FLUIDSIM_GRAVITY,
	FLUIDSIM_SMOKET,
	FLUIDSIM_MAXDENSITY,
	FLUIDSIM_ALGO_DENSITY = 1035,
	FLUIDSIM_ALGO_D_LINEAR = 0,
	FLUIDSIM_ALGO_D_COSINE,
	FLUIDSIM_ALGO_D_HERMITE,
	FLUIDSIM_TRACEALGO_D = 1036,
	FLUIDSIM_TRACEALGO_D_EULER1ST = 0,
	FLUIDSIM_TRACEALGO_D_RUNGA2ND,
	FLUIDSIM_TRACEALGO_D_RUNGA3RD,
	FLUIDSIM_TRACEALGO_D_RUNGA4TH,
	FLUIDSIM_CONVECT_SMOKE = 1037,

	//HEAT TAB
	FLUIDSIM_AMBIENT = 1038,
	FLUIDSIM_ALGO_TEMPERATURE = 1039,
	FLUIDSIM_ALGO_T_LINEAR = 0,
	FLUIDSIM_ALGO_T_COSINE,
	FLUIDSIM_ALGO_T_HERMITE,
	FLUIDSIM_TRACEALGO_T = 1040,
	FLUIDSIM_TRACEALGO_T_EULER1ST = 0,
	FLUIDSIM_TRACEALGO_T_RUNGA2ND,
	FLUIDSIM_TRACEALGO_T_RUNGA3RD,
	FLUIDSIM_TRACEALGO_T_RUNGA4TH,
	FLUIDSIM_TEMPTYPE = 1041,
	FLUIDSIM_TEMPTYPE_FULL_UC = 0,
	FLUIDSIM_TEMPTYPE_BUOYSMOKE,
	FLUIDSIM_TEMPTYPE_FULL,
	FLUDISIM_TEMPERATURE_DIFFUSION = 1042,
	FLUIDSIM_MAXTEMPERATURE,
	FLUIDSIM_COOL_PHYSICAL,		
	FLUIDSIM_BOUYANCY,
	FLUIDSIM_COOLING,
	FLUIDSIM_AIRDENSITY,
	FLUIDSIM_HEATEXP,
	FLUIDSIM_CONVECT_HEAT,

	//FUEL TAB
	FLUIDSIM_COMBUSTION_PRESS = 1050,
	FLUIDSIM_FUELDISSIPATION,
	FLUIDSIM_COMBUSTIONDENSITY,
	FLUIDSIM_BURNINGRATE,
	FLUIDSIM_FUELDIFFUSION,
	FLUIDSIM_IGNITION_TEMP,
	FLUIDSIM_OUTPUTHEAT,
	FLUIDSIM_CONVECT_FUEL,
	FLUIDSIM_ALGO_FUEL = 1058,
	FLUIDSIM_ALGO_F_LINEAR = 0,
	FLUIDSIM_ALGO_F_COSINE,
	FLUIDSIM_ALGO_F_HERMITE,
	FLUIDSIM_TRACEALGO_F = 1059,
	FLUIDSIM_TRACEALGO_F_EULER1ST = 0,
	FLUIDSIM_TRACEALGO_F_RUNGA2ND,
	FLUIDSIM_TRACEALGO_F_RUNGA3RD,
	FLUIDSIM_TRACEALGO_F_RUNGA4TH,

	//FLUID PARTICLES TAB
	FLUIDSIM_FLUIDPARTICLES_CONSTANTDENSITY = 1060,
	FLUIDSIM_FLUIDPARTICLES_IPOLEMISSION,
	FLUIDSIM_FLUIDPARTICLES_DENSITY_USEAGE,
	FLUIDSIM_FLUIDPARTICLES_DENSITY_AGE,
	FLUIDSIM_FLUIDPARTICLES_CONSTANTVELOCITY,
	FLUIDSIM_FLUIDPARTICLES_IMPACTVELOCITY,
	FLUIDSIM_CREATE_SIMPLEPARTICLES_OUTSIDE,
	FLUIDSIM_SIMPLEPARTICLES_OUTGOING_VELOCITY,

	//SIMPLEPARTICLES TAB
	FLUIDSIM_SIMPLEPARTICLES_USE,
	FLUIDSIM_SIMPLEPARTICLES_EMITTER,
	FLUIDSIM_SIMPLEPARTICLES_ATTACHOBJECTS,
	FLUIDSIM_SIMPLEPARTICLES_SPHERE,
	FLUIDSIM_SIMPLEPARTICLES_RAD,
	FLUIDSIM_SIMPLEPARTICLES_RAD_VAR,
	FLUIDSIM_SIMPLEPARTICLES_DENSITY,
	FLUIDSIM_SIMPLEPARTICLES_HEAT,
	FLUIDSIM_SIMPLEPARTICLES_FUEL,
	FLUIDSIM_SIMPLEPARTICLES_PRESSURE = 1077,
	FLUIDSIM_SIMPLEPARTICLES_COLOR,
	FLUIDSIM_SIMPLEPARTICLES_IMPACTVELOCITY,
	FLUIDSIM_SIMPLEPARTICLES_DENSITY_USEAGE,
	FLUIDSIM_SIMPLEPARTICLES_AGEGRADIENT,
	FLUIDSIM_CREATE_FLUIDPARTICLES_INSIDE,
	FLUIDSIM_SP_TO_FP_RAD,
	FLUIDSIM_SP_TO_FP_RAD_VAR,

	//CACHE TAB	
	FLUIDSIM_CACHE_USECACHE_FLUID = 1085,
	FLUIDSIM_CACHE_SAVEMODE,
		FLUIDSIM_CACHE_SAVEMODE_RAM = 0,
		FLUIDSIM_CACHE_SAVEMODE_DISK,
		FLUIDSIM_CACHE_SAVEMODE_DISKRENDER,
	FLUIDSIM_CACHE_FILE = 1087,
	FLUIDSIM_CACHE_CLEAR,
	FLUIDSIM_CACHE_SINGLEFRAME,
	FLUIDSIM_CACHE_USECACHE_SMOKE,
	FLUIDSIM_CACHE_USECACHE_HEAT,
	FLUIDSIM_CACHE_FILENAME,
	FLUIDSIM_CACHE_USECACHE_FUEL,
	FLUIDSIM_CACHE_MODE = 1094,
		FLUIDSIM_CACHE_MODE_OFF = 0,
		FLUIDSIM_CACHE_MODE_LOAD,
		FLUIDSIM_CACHE_MODE_SAVE,
	FLUIDSIM_CACHE_USECACHE_FIRE = 1095,
	FLUIDSIM_CACHE_USECACHE_COLOR,
	FLUIDSIM_CACHE_USECACHE_FLOWMAP,
	FLUIDSIM_CACHE_CFRAME,

	//OTHER
	FLUIDSIM_CELLS_CNT = 1099,
	FLUIDSIM_CELLS_CNT_R,

	//ADDED
	FLUIDSIM_GGRAVITY = 1105,
	FLUIDSIM_VORTKERNEL = 1106,
		FLUIDSIM_VORTKERNEL_POLY = 0,
		FLUIDSIM_VORTKERNEL_GAUSSAIN,
		FLUIDSIM_VORTKERNEL_CUSTOM,
		FLUIDSIM_VORTKERNEL_STANDARD,
		FLUIDSIM_VORTKERNEL_SPIKE,
		FLUIDSIM_VORTKERNEL_SMOOTH,
	FLUIDSIM_CUSTOMKERNEL = 1107,
	FLUIDSIM_STRETCHLENGTH,

	FLUIDSIM_SP_TO_FP_DENSITY,
	FLUIDSIM_SP_TO_FP_HEAT,
	FLUIDSIM_SP_TO_FP_FUEL,
	FLUIDSIM_SP_TO_FP_PRESSURE,
	FLUIDSIM_SP_TO_FP_COLOR,

	FLUIDSIM_THINKINGPARTICLES_USE,
	FLUIDSIM_THINKINGPARTICLES_DENSITY,
	FLUIDSIM_THINKINGPARTICLES_HEAT,
	FLUIDSIM_THINKINGPARTICLES_FUEL,
	FLUIDSIM_THINKINGPARTICLES_PRESSURE,
	FLUIDSIM_THINKINGPARTICLES_COLOR,
	FLUIDSIM_THINKINGPARTICLES_IMPACTVELOCITY,
	FLUIDSIM_THINKINGPARTICLES_DENSITY_USEAGE,
	FLUIDSIM_THINKINGPARTICLES_AGEGRADIENT,

	FLUIDSIM_VORTEX_ALIGN = 1123,
	FLUIDSIM_VORTEX_ALIGN_X = 0,
	FLUIDSIM_VORTEX_ALIGN_Y,
	FLUIDSIM_VORTEX_ALIGN_Z,
	FLUIDSIM_VORTEX_ALIGN_XYZ,			
	FLUIDSIM_VORTEX_ALIGN_SPHERICAL,
	FLUIDSIM_VORTEX_ALIGN_BOX,
	FLUIDSIM_VORTEX_ALIGN_CYLINDRICAL,
	FLUIDSIM_VORTEX_ALIGN_RANDOM,
	FLUIDSIM_VORTEX_ALIGN_INVERT = 1124,
	FLUIDSIM_VORTEX_XYZ,
	FLUIDSIM_VORTEX_SAMPLES,
	FLUIDSIM_VORTEX_SAMPLESVAR,
	FLUIDSIM_VORTEX_AGE,
	FLUIDSIM_VORTEX_AGEVAR,
	FLUIDSIM_VORTEX_RADIUS,	
	FLUIDSIM_VORTEX_RADIUSVAR,

	FLUIDSIM_ALGO_TEX = 1132,
	FLUIDSIM_ALGO_TEX_LINEAR = 0,
	FLUIDSIM_ALGO_TEX_COSINE,
	FLUIDSIM_ALGO_TEX_HERMITE,
	FLUIDSIM_TRACEALGO_TEX = 1133,
	FLUIDSIM_TRACEALGO_TEX_EULER1ST = 0,
	FLUIDSIM_TRACEALGO_TEX_RUNGA2ND,
	FLUIDSIM_TRACEALGO_TEX_RUNGA3RD,
	FLUIDSIM_TRACEALGO_TEX_RUNGA4TH,
	FLUIDSIM_USEMAXSPEED = 1134,
	FLUIDSIM_MAXSPEED = 1135,
	FLUIDSIM_USEMAXSPEED_OFF = 0,
	FLUIDSIM_USEMAXSPEED_CLAMP,
	FLUIDSIM_USEMAXSPEED_RESCALE,
	FLUIDSIM_SUBTIMESTEPS = 1136,
	FLUIDSIM_VORTICITY_GRAD,
	FLUIDSIM_VORTICITY_GRADAXIS = 1138,
	FLUIDSIM_VORTICITY_GRADAXIS_X = 0,
	FLUIDSIM_VORTICITY_GRADAXIS_Y,
	FLUIDSIM_VORTICITY_GRADAXIS_Z,
	FLUIDSIM_VORTICITY_DIRECT = 1139,
	FLUIDSIM_BOUYANCY_GRAD = 1140,
	FLUIDSIM_BOUYANCY_GRADAXIS = 1141,
	FLUIDSIM_BOUYANCY_GRADAXIS_X = 0,
	FLUIDSIM_BOUYANCY_GRADAXIS_Y,
	FLUIDSIM_BOUYANCY_GRADAXIS_Z,
	FLUIDSIM_BOUYANCY_FEATURES = 1142,
	FLUIDSIM_BOUYANCY_NORMAL = 0,
	FLUIDSIM_BOUYANCY_GRADIENT,
	FLUIDSIM_BOUYANCY_DIRECT = 1143,
	FLUIDSIM_CHANNEL_COLOR,
	FLUIDSIM_TRACEALGO_COLOR = 1145,
	FLUIDSIM_TRACEALGO_COLOR_EULER1ST = 0,
	FLUIDSIM_TRACEALGO_COLOR_RUNGA2ND,
	FLUIDSIM_TRACEALGO_COLOR_RUNGA3RD,
	FLUIDSIM_TRACEALGO_COLOR_RUNGA4TH,
	FLUIDSIM_ALGO_COLOR = 1146,
	FLUIDSIM_ALGO_COLOR_LINEAR = 0,
	FLUIDSIM_ALGO_COLOR_COSINE,
	FLUIDSIM_ALGO_COLOR_HERMITE,	
	FLUIDSIM_DISSIPATION_COLOR = 1147,
	FLUIDSIM_BOUNDARY_SLIP,
	FLUIDSIM_BOUNDARY_SLIP_FREE = 0,
	FLUIDSIM_BOUNDARY_SLIP_NO,
	FLUIDSIM_BOUNDARY_SLIP_ROUGH,
	FLUIDSIM_SIMULATIONTYPE = 1149,
		FLUIDSIM_SIMULATIONTYPE_AIR = 0,
		FLUIDSIM_SIMULATIONTYPE_WATER,
		FLUIDSIM_SIMULATIONTYPE_SMOKE,
		FLUIDSIM_SIMULATIONTYPE_SMOKETARGET,
		FLUIDSIM_SIMULATIONTYPE_FIRE,
		FLUIDSIM_SIMULATIONTYPE_COMBUSTION,
		FLUIDSIM_SIMULATIONTYPE_VISCOSITY,
		FLUIDSIM_SIMULATIONTYPE_SAND,
	FLUIDSIM_CHANNEL_FLUIDPARTICLES = 1150,
	FLUIDSIM_CHANNEL_SIMPLEPARTICLES,
	FLUIDSIM_CHANNEL_THINKINGPARTICLES,
	FLUIDSIM_CHANNEL_ADVANCED,
	FLUIDSIM_TRACEALGO_FIRE = 1154,
	FLUIDSIM_TRACEALGO_FIRE_EULER1ST = 0,
	FLUIDSIM_TRACEALGO_FIRE_RUNGA2ND,
	FLUIDSIM_TRACEALGO_FIRE_RUNGA3RD,
	FLUIDSIM_TRACEALGO_FIRE_RUNGA4TH,
	FLUIDSIM_ALGO_FIRE = 1155,
	FLUIDSIM_ALGO_FIRE_LINEAR = 0,
	FLUIDSIM_ALGO_FIRE_COSINE,
	FLUIDSIM_ALGO_FIRE_HERMITE,	
	FLUIDSIM_SMOKETARGET = 1156,
	FLUIDSIM_SMOKETARGET_DIFFUSION,
	FLUIDSIM_SMOKETARGET_ITER,
	FLUIDSIM_SMOKETARGET_SET,
	FLUIDSIM_SMOKETARGET_ATTRACT,
	FLUIDSIM_SMOKETARGET_ATTENUATE,
	FLUIDSIM_TRANSPORTTYPE_TEX = 1162,
	FLUIDSIM_TRANSPORTTYPE_TEX_1ST = 0,
	FLUIDSIM_TRANSPORTTYPE_TEX_2ND,
	FLUIDSIM_TRANSPORTTYPE_FLUID = 1163,
	FLUIDSIM_TRANSPORTTYPE_FLUID_1ST = 0,
	FLUIDSIM_TRANSPORTTYPE_FLUID_2ND,
	FLUIDSIM_TRANSPORTTYPE_FLUID_MIX,
	FLUIDSIM_TRANSPORTTYPE_FLUID_MIXPHASES,
	FLUIDSIM_TRANSPORTTYPE_TEMPERATURE = 1164,
	FLUIDSIM_TRANSPORTTYPE_TEMPERATURE_1ST = 0,
	FLUIDSIM_TRANSPORTTYPE_TEMPERATURE_2ND,
	FLUIDSIM_TRANSPORTTYPE_COLOR = 1165,
	FLUIDSIM_TRANSPORTTYPE_COLOR_1ST = 0,
	FLUIDSIM_TRANSPORTTYPE_COLOR_2ND,
	FLUIDSIM_TRANSPORTTYPE_FUEL = 1166,
	FLUIDSIM_TRANSPORTTYPE_FUEL_1ST = 0,
	FLUIDSIM_TRANSPORTTYPE_FUEL_2ND,
	FLUIDSIM_TRANSPORTTYPE_SMOKE = 1167,
	FLUIDSIM_TRANSPORTTYPE_SMOKE_1ST = 0,
	FLUIDSIM_TRANSPORTTYPE_SMOKE_2ND,
	FLUIDSIM_TRANSPORTTYPE_SMOKE_1ST_MASSMOMENTUM = 4,
	FLUIDSIM_TRANSPORTTYPE_SMOKE_2ND_MASSMOMENTUM,
	FLUIDSIM_TRANSPORTTYPE_FIRE = 1168,
	FLUIDSIM_TRANSPORTTYPE_FIRE_1ST = 0,
	FLUIDSIM_TRANSPORTTYPE_FIRE_2ND,
	FLUIDSIM_SOLVERACCURACY = 1169,
	FLUIDSIM_SOLVERACCURACY_1E3 = 0,
	FLUIDSIM_SOLVERACCURACY_1E4,
	FLUIDSIM_SOLVERACCURACY_1E5,
	FLUIDSIM_SOLVERACCURACY_1E6,
	FLUIDSIM_SOLVERACCURACY_1E7,
	FLUIDSIM_SOLVERACCURACY_1E8,
	FLUIDSIM_SOLVERACCURACY_1E10,
	FLUIDSIM_SOLVERACCURACY_1E12,
	FLUIDSIM_SOLVERACCURACY_1E16,
	FLUIDSIM_GRIDCELLS_SUBDIVISION = 1170,
	FLUIDSIM_SUBDIVISION_ONLYRENDER,
	FLUIDSIM_SUBDIVISION_TYPE = 1172,
	FLUIDSIM_SUBDIVISION_TYPE_LINEAR = 0,
	FLUIDSIM_SUBDIVISION_TYPE_COSINE,
	FLUIDSIM_SUBDIVISION_TYPE_CUBIC,
	FLUIDSIM_SUBDIVISION_TYPE_CUSTOM,
	FLUIDSIM_VORTICITYHRES = 1173,
	FLUIDSIM_VORTEXSUBD_SAMPLING = 1174,
	FLUIDSIM_VORTEXSUBD_SAMPLING_LOW = 0,
	FLUIDSIM_VORTEXSUBD_SAMPLING_HIGH,
	FLUIDSIM_VORTEXSUBD_TRANSPORT = 1175,
	FLUIDSIM_VORTEXSUBD_TRANSPORT_LOW = 0,
	FLUIDSIM_VORTEXSUBD_TRANSPORT_HIGH,
	FLUIDSIM_VORTEXSUBD_TRANSPORT_LOWHIGH,
	FLUIDSIM_CELLS_CNTSUB = 1176,
	FLUIDSIM_CELLS_CNT_RSUB,
	FLUIDSIM_MEMORY_R,
	FLUIDSIM_MEMORY_RSUB,
	FLUIDSIM_CONVECT_FLUID,
	FLUIDSIM_CONVECT_FIRE,
	FLUIDSIM_CONVECT_COLOR,
	FLUIDSIM_CONVECT_TEX,
	FLUIDSIM_ADAPTIVEGRID,
	FLUIDSIM_ADDFLUIDOBJECTBDR,
	FLUIDSIM_ADDFLUIDOBJECTEVENT,
	FLUIDSIM_CACHEFILE_INFO,
	FLUIDSIM_CACHE_USECACHE_EXTERNAL,
	FLUIDSIM_BODYFORCES,
	FLUIDSIM_SLIPAMOUNT,
	FLUIDSIM_OBSTACLE_FREESLIP = 1191,
	FLUIDSIM_STARTGRID_FILE = 1192,
	FLUIDSIM_STARTGRID_FILENAME,
	FLUIDSIM_STARTGRID_FRAME,
	FLUIDSIM_STARTGRID_MIX,
	FLUIDSIM_STARTGRID_FLUID,
	FLUIDSIM_STARTGRID_SMOKE,
	FLUIDSIM_STARTGRID_HEAT,
	FLUIDSIM_STARTGRID_FUEL,
	FLUIDSIM_STARTGRID_FIRE,
	FLUIDSIM_STARTGRID_COLOR,
	FLUIDSIM_STARTGRID_FLOWMAP,

	FLUIDSIM_TRACEALGO_FP = 1203,
	FLUIDSIM_TRACEALGO_FP_EULER1ST = 0,
	FLUIDSIM_TRACEALGO_FP_RUNGA2ND,
	FLUIDSIM_TRACEALGO_FP_RUNGA3RD,
	FLUIDSIM_TRACEALGO_FP_RUNGA4TH,
	FLUIDSIM_TRACEALGO_VP = 1204,
	FLUIDSIM_TRACEALGO_VP_EULER1ST = 0,
	FLUIDSIM_TRACEALGO_VP_RUNGA2ND,
	FLUIDSIM_TRACEALGO_VP_RUNGA3RD,
	FLUIDSIM_TRACEALGO_VP_RUNGA4TH,
	FLUIDSIM_SUBSTEPS_FP = 1205,
	FLUIDSIM_SUBSTEPS_VP,
	FLUIDSIM_STARTGRID_INFO,

	FLUIDSIM_VORTEXSP_ALIGN = 1208,
	FLUIDSIM_VORTEXSP_ALIGN_X = 0,
	FLUIDSIM_VORTEXSP_ALIGN_Y,
	FLUIDSIM_VORTEXSP_ALIGN_Z,
	FLUIDSIM_VORTEXSP_ALIGN_XYZ,			
	FLUIDSIM_VORTEXSP_ALIGN_SPHERICAL,
	FLUIDSIM_VORTEXSP_ALIGN_BOX,
	FLUIDSIM_VORTEXSP_ALIGN_CYLINDRICAL,
	FLUIDSIM_VORTEXSP_ALIGN_RANDOM,
	FLUIDSIM_VORTEXSP_ALIGN_INVERT = 1209,
	FLUIDSIM_VORTEXSP_XYZ,
	FLUIDSIM_VORTEXSP_SAMPLES,
	FLUIDSIM_VORTEXSP_SAMPLESVAR,
	FLUIDSIM_VORTEXSP_AGE,
	FLUIDSIM_VORTEXSP_AGEVAR,
	FLUIDSIM_VORTEXSP_RADIUS,	
	FLUIDSIM_VORTEXSP_RADIUSVAR,
	FLUIDSIM_VORTEXTP_ALIGN = 1217,
	FLUIDSIM_VORTEXTP_ALIGN_X = 0,
	FLUIDSIM_VORTEXTP_ALIGN_Y,
	FLUIDSIM_VORTEXTP_ALIGN_Z,
	FLUIDSIM_VORTEXTP_ALIGN_XYZ,			
	FLUIDSIM_VORTEXTP_ALIGN_SPHERICAL,
	FLUIDSIM_VORTEXTP_ALIGN_BOX,
	FLUIDSIM_VORTEXTP_ALIGN_CYLINDRICAL,
	FLUIDSIM_VORTEXTP_ALIGN_RANDOM,
	FLUIDSIM_VORTEXTP_ALIGN_INVERT = 1218,
	FLUIDSIM_VORTEXTP_XYZ,
	FLUIDSIM_VORTEXTP_SAMPLES,
	FLUIDSIM_VORTEXTP_SAMPLESVAR,
	FLUIDSIM_VORTEXTP_AGE,
	FLUIDSIM_VORTEXTP_AGEVAR,
	FLUIDSIM_VORTEXTP_RADIUS,	
	FLUIDSIM_VORTEXTP_RADIUSVAR,
	FLUIDSIM_FLUIDPARTICLES_WINDDIR = 1226,
	FLUIDSIM_FLUIDPARTICLES_WINDDIR_X = 0,
	FLUIDSIM_FLUIDPARTICLES_WINDDIR_Y,
	FLUIDSIM_FLUIDPARTICLES_WINDDIR_Z,
	FLUIDSIM_FLUIDPARTICLES_WINDDIR_VELOCITY,
	FLUIDSIM_FLUIDPARTICLES_MASSINFLUENCE = 1227,
	FLUIDSIM_FLUIDPARTICLES_SIZEINFLUENCE,
	FLUIDSIM_SIMPLEPARTICLES_WINDDIR = 1229,
	FLUIDSIM_SIMPLEPARTICLES_WINDDIR_X = 0,
	FLUIDSIM_SIMPLEPARTICLES_WINDDIR_Y,
	FLUIDSIM_SIMPLEPARTICLES_WINDDIR_Z,
	FLUIDSIM_SIMPLEPARTICLES_WINDDIR_VELOCITY,
	FLUIDSIM_SIMPLEPARTICLES_MASSINFLUENCE = 1230,
	FLUIDSIM_SIMPLEPARTICLES_SIZEINFLUENCE,
	FLUIDSIM_THINKINGPARTICLES_WINDDIR = 1232,
	FLUIDSIM_THINKINGPARTICLES_WINDDIR_X = 0,
	FLUIDSIM_THINKINGPARTICLES_WINDDIR_Y,
	FLUIDSIM_THINKINGPARTICLES_WINDDIR_Z,
	FLUIDSIM_THINKINGPARTICLES_WINDDIR_VELOCITY,
	FLUIDSIM_THINKINGPARTICLES_WINDDIR_SPIN,
	FLUIDSIM_THINKINGPARTICLES_WINDDIR_ALIGNMENTX,
	FLUIDSIM_THINKINGPARTICLES_WINDDIR_ALIGNMENTY,				
	FLUIDSIM_THINKINGPARTICLES_WINDDIR_ALIGNMENTZ,
	FLUIDSIM_THINKINGPARTICLES_MASSINFLUENCE = 1233,
	FLUIDSIM_THINKINGPARTICLES_SIZEINFLUENCE,

	FLUIDSIM_FLUIDPARTICLES_RADFALLOFF = 1235,
	FLUIDSIM_FLUIDPARTICLES_RADFALLOFF_NONE = 0,
	FLUIDSIM_FLUIDPARTICLES_RADFALLOFF_LINEAR,
	FLUIDSIM_FLUIDPARTICLES_RADFALLOFF_CUBIC,
	FLUIDSIM_FLUIDPARTICLES_RADFALLOFF_CUSTOM,
	FLUIDSIM_FLUIDPARTICLES_RADFALLOFF_GRAD = 1236,
	FLUIDSIM_SIMPLEPARTICLES_RADFALLOFF = 1237,
	FLUIDSIM_SIMPLEPARTICLES_RADFALLOFF_NONE = 0,
	FLUIDSIM_SIMPLEPARTICLES_RADFALLOFF_LINEAR,
	FLUIDSIM_SIMPLEPARTICLES_RADFALLOFF_CUBIC,
	FLUIDSIM_SIMPLEPARTICLES_RADFALLOFF_CUSTOM,
	FLUIDSIM_SIMPLEPARTICLES_RADFALLOFF_GRAD = 1238,
	FLUIDSIM_THINKINGPARTICLES_RADFALLOFF = 1239,
	FLUIDSIM_THINKINGPARTICLES_RADFALLOFF_NONE = 0,
	FLUIDSIM_THINKINGPARTICLES_RADFALLOFF_LINEAR,
	FLUIDSIM_THINKINGPARTICLES_RADFALLOFF_CUBIC,
	FLUIDSIM_THINKINGPARTICLES_RADFALLOFF_CUSTOM,
	FLUIDSIM_THINKINGPARTICLES_RADFALLOFF_GRAD = 1240,

	FLUIDSIM_FLUIDPARTICLES_MEDIARADFALLOFF = 1241,
	FLUIDSIM_FLUIDPARTICLES_MEDIARADFALLOFF_NONE = 0,
	FLUIDSIM_FLUIDPARTICLES_MEDIARADFALLOFF_LINEAR,
	FLUIDSIM_FLUIDPARTICLES_MEDIARADFALLOFF_CUBIC,
	FLUIDSIM_FLUIDPARTICLES_MEDIARADFALLOFF_CUSTOM,
	FLUIDSIM_FLUIDPARTICLES_MEDIARADFALLOFF_GRAD = 1242,
	FLUIDSIM_SIMPLEPARTICLES_MEDIARADFALLOFF = 1243,
	FLUIDSIM_SIMPLEPARTICLES_MEDIARADFALLOFF_NONE = 0,
	FLUIDSIM_SIMPLEPARTICLES_MEDIARADFALLOFF_LINEAR,
	FLUIDSIM_SIMPLEPARTICLES_MEDIARADFALLOFF_CUBIC,
	FLUIDSIM_SIMPLEPARTICLES_MEDIARADFALLOFF_CUSTOM,
	FLUIDSIM_SIMPLEPARTICLES_MEDIARADFALLOFF_GRAD = 1244,
	FLUIDSIM_THINKINGPARTICLES_MEDIARADFALLOFF = 1245,
	FLUIDSIM_THINKINGPARTICLES_MEDIARADFALLOFF_NONE = 0,
	FLUIDSIM_THINKINGPARTICLES_MEDIARADFALLOFF_LINEAR,
	FLUIDSIM_THINKINGPARTICLES_MEDIARADFALLOFF_CUBIC,
	FLUIDSIM_THINKINGPARTICLES_MEDIARADFALLOFF_CUSTOM,
	FLUIDSIM_THINKINGPARTICLES_MEDIARADFALLOFF_GRAD = 1246,
	FLUIDSIM_ADDGROUPOBJECT,
	FLUIDSIM_GROUPLIST,
	FLUIDSIM_MAXEMISSIONSTEPS,
	FLUIDSIM_USESTARTGRID,
	FLUIDSIM_STARTGRID_INIT,

	FLUIDSIM_VORTICITY_RADIUS_L1,
	FLUIDSIM_VORTICITYHRES_L1,
	FLUIDSIM_STRETCHLENGTH_L1,
	FLUIDSIM_VORTKERNEL_L1 = 1255,
		FLUIDSIM_VORTKERNEL_L1_GAUSSAIN = 1,
		FLUIDSIM_VORTKERNEL_L1_POLY = 0,
		FLUIDSIM_VORTKERNEL_L1_CUSTOM = 2,
		FLUIDSIM_VORTKERNEL_L1_STANDARD,
		FLUIDSIM_VORTKERNEL_L1_SPIKE,
		FLUIDSIM_VORTKERNEL_L1_SMOOTH,
	FLUIDSIM_CUSTOMKERNEL_L1 = 1256,

	FLUIDSIM_VORTICITY_RADIUS_L2,
	FLUIDSIM_VORTICITYHRES_L2,
	FLUIDSIM_STRETCHLENGTH_L2,
	FLUIDSIM_VORTKERNEL_L2 = 1260,
		FLUIDSIM_VORTKERNEL_L2_GAUSSAIN = 1,
		FLUIDSIM_VORTKERNEL_L2_POLY = 0,
		FLUIDSIM_VORTKERNEL_L2_CUSTOM = 2,
		FLUIDSIM_VORTKERNEL_L2_STANDARD,
		FLUIDSIM_VORTKERNEL_L2_SPIKE,
		FLUIDSIM_VORTKERNEL_L2_SMOOTH,
	FLUIDSIM_CUSTOMKERNEL_L2 = 1261,

	FLUIDSIM_VORTICITY_RADIUS_L3,
	FLUIDSIM_VORTICITYHRES_L3,
	FLUIDSIM_STRETCHLENGTH_L3,
	FLUIDSIM_VORTKERNEL_L3 = 1265,
		FLUIDSIM_VORTKERNEL_L3_GAUSSAIN = 1,
		FLUIDSIM_VORTKERNEL_L3_POLY = 0,
		FLUIDSIM_VORTKERNEL_L3_CUSTOM = 2,
		FLUIDSIM_VORTKERNEL_L3_STANDARD,
		FLUIDSIM_VORTKERNEL_L3_SPIKE,
		FLUIDSIM_VORTKERNEL_L3_SMOOTH,
	FLUIDSIM_CUSTOMKERNEL_L3 = 1266,

	FLUIDSIM_VORTICITY_RADIUS_L4,
	FLUIDSIM_VORTICITYHRES_L4,
	FLUIDSIM_STRETCHLENGTH_L4,
	FLUIDSIM_VORTKERNEL_L4 = 1270,
		FLUIDSIM_VORTKERNEL_L4_GAUSSAIN = 1,
		FLUIDSIM_VORTKERNEL_L4_POLY = 0,
		FLUIDSIM_VORTKERNEL_L4_CUSTOM = 2,
		FLUIDSIM_VORTKERNEL_L4_STANDARD,
		FLUIDSIM_VORTKERNEL_L4_SPIKE,
		FLUIDSIM_VORTKERNEL_L4_SMOOTH,
	FLUIDSIM_CUSTOMKERNEL_L4 = 1271,

	FLUIDSIM_VORTEX_SUBGRIDLAYER = 1272,
	FLUIDSIM_VORTEX_SUBGRIDLAYER_PARENT = 0,
	FLUIDSIM_VORTEXSP_SUBGRIDLAYER = 1273,
	FLUIDSIM_VORTEXSP_SUBGRIDLAYER_PARENT = 0,
	FLUIDSIM_VORTEXTP_SUBGRIDLAYER = 1274,
	FLUIDSIM_VORTEXTP_SUBGRIDLAYER_PARENT = 0,
	FLUIDSIM_VORTEX_SUBGRIDLAYER_L1 = 1275,
	FLUIDSIM_VORTEX_SUBGRIDLAYER_L1_PARENT = 0,
	FLUIDSIM_VORTEX_SUBGRIDLAYER_L2 = 1276,
	FLUIDSIM_VORTEX_SUBGRIDLAYER_L2_PARENT = 0,
	FLUIDSIM_VORTEX_SUBGRIDLAYER_L3 = 1277,
	FLUIDSIM_VORTEX_SUBGRIDLAYER_L3_PARENT = 0,
	FLUIDSIM_VORTEX_SUBGRIDLAYER_L4 = 1278,
	FLUIDSIM_VORTEX_SUBGRIDLAYER_L4_PARENT = 0,

	FLUIDSIM_VORTEXSUBD_SAMPLING_L3 = 1279,
	FLUIDSIM_VORTEXSUBD_SAMPLING_L3_LOW = 0,
	FLUIDSIM_VORTEXSUBD_SAMPLING_L3_HIGH,
	FLUIDSIM_VORTEXSUBD_SAMPLING_L4 = 1280,
	FLUIDSIM_VORTEXSUBD_SAMPLING_L4_LOW = 0,
	FLUIDSIM_VORTEXSUBD_SAMPLING_L4_HIGH,
	FLUIDSIM_FIRESOOT = 1281,
	FLUIDSIM_FIRESOOTCURVE,
	FLUIDSIM_BOUYANCY_DIR,

	FLUIDSIM_FIRE_SCENELIGHTS = 1284,
	FLUIDSIM_FIRE_SCENELIGHTS_OFF = 0,
	FLUIDSIM_FIRE_SCENELIGHTS_ON,
	FLUIDSIM_FIRE_SCENELIGHTS_RENDER,
	FLUIDSIM_FIRE_SCENELIGHTS_TIMING = 1285,
	FLUIDSIM_FIRE_SCENELIGHTS_RATE,
	FLUIDSIM_FIRE_SCENELIGHTS_INTENSTIY,
	FLUIDSIM_FIRE_SCENELIGHTS_RADIUS,
	FLUIDSIM_FIRE_SCENELIGHTS_COLORING = 1289,
	FLUIDSIM_FIRE_SCENELIGHTS_COLORING_PHYSICAL = 0,
	FLUIDSIM_FIRE_SCENELIGHTS_COLORING_SHADER,
	FLUIDSIM_FIRE_SCENELIGHTS_COLORING_SHADERLINK = 1290,
	FLUIDSIM_FUELPERFRAME,
	FLUIDSIM_CACHE_FLUID,
	FLUIDSIM_CACHE_SMOKE,
	FLUIDSIM_CACHE_HEAT,
	FLUIDSIM_CACHE_FUEL,
	FLUIDSIM_CACHE_FIRE,
	FLUIDSIM_CACHE_COLOR,
	FLUIDSIM_CACHE_FLOWMAP,
	FLUIDSIM_CHANNEL_XPFORCE,
	FLUIDSIM_CHANNEL_BOUNDARIES = 1300,
	FLUIDSIM_CHANNEL_SIMMIX,
	FLUIDSIM_CHANNEL_FORCES,
	FLUIDSIM_CHANNEL_TURBULENCE,
	FLUIDSIM_CACHEPREVIEW,
	FLUIDSIM_VOXELSIZE,
	FLUIDSIM_BOUNDARY_FREESLIP,
	FLUIDSIM_OBSTACLE_SLIP = 1307,
	FLUIDSIM_OBSTACLE_SLIP_FREE = 0,
	FLUIDSIM_OBSTACLE_SLIP_NO,
	FLUIDSIM_OBSTACLE_SLIP_ROUGH,
	FLUIDSIM_FSSMIXERLIST = 1308,		
	FLUIDSIM_FLUIDPARTICLES_IPOLEMISSIONHEAT,
	FLUIDSIM_FLUIDPARTICLES_IPOLEMISSIONFUEL,
	FLUIDSIM_FLUIDPARTICLES_IPOLEMISSIONFIRE,
	FLUIDSIM_FLUIDPARTICLES_IPOLEMISSIONCOLOR,
	FLUIDSIM_FLUIDPARTICLES_IPOLEMISSIONWIND,
	FLUIDSIM_FLUIDPARTICLES_IPOLEMISSIONPRESSURE,
	FLUIDSIM_SIMPLEPARTICLES_IPOLEMISSION,
	FLUIDSIM_SIMPLEPARTICLES_IPOLEMISSIONHEAT,
	FLUIDSIM_SIMPLEPARTICLES_IPOLEMISSIONFUEL,
	FLUIDSIM_SIMPLEPARTICLES_IPOLEMISSIONFIRE,
	FLUIDSIM_SIMPLEPARTICLES_IPOLEMISSIONCOLOR,
	FLUIDSIM_SIMPLEPARTICLES_IPOLEMISSIONWIND,
	FLUIDSIM_SIMPLEPARTICLES_IPOLEMISSIONPRESSURE,
	FLUIDSIM_THINKINGPARTICLES_IPOLEMISSION,
	FLUIDSIM_THINKINGPARTICLES_IPOLEMISSIONHEAT,
	FLUIDSIM_THINKINGPARTICLES_IPOLEMISSIONFUEL,
	FLUIDSIM_THINKINGPARTICLES_IPOLEMISSIONFIRE,
	FLUIDSIM_THINKINGPARTICLES_IPOLEMISSIONCOLOR,
	FLUIDSIM_THINKINGPARTICLES_IPOLEMISSIONWIND,
	FLUIDSIM_THINKINGPARTICLES_IPOLEMISSIONPRESSURE,
	FLUIDSIM_VORTICITYPARTICLES_IPOLEMISSION,
	FLUIDSIM_VORTICITYPARTICLES_IPOLEMISSION_L1,
	FLUIDSIM_VORTICITYPARTICLES_IPOLEMISSION_L2,
	FLUIDSIM_VORTICITYPARTICLES_IPOLEMISSION_L3,
	FLUIDSIM_VORTICITYPARTICLES_IPOLEMISSION_L4,
	FLUIDSIM_CACHE_USECACHE_FP,
	FLUIDSIM_CACHE_FP,
	FLUIDSIM_CACHE_FILENAME_NAME,
	FLUIDSIM_STARTGRID_FILENAME_NAME,
	FLUIDSIM_CHANNEL_MEMORY,
	FlUIDSIM_GMEMORY_FIELD = 1342,
		FlUIDSIM_GMEMORY_FIELD_SMOKE = 0,
		FlUIDSIM_GMEMORY_FIELD_HEAT,
		FlUIDSIM_GMEMORY_FIELD_FUEL,				
		FlUIDSIM_GMEMORY_FIELD_FIRE, 
	FlUIDSIM_GMEMORY_STORE = 1343,
	FlUIDSIM_GMEMORY_DISSIPATE,
	FLUIDSIM_BOUNDARY_CHECKADVECT,
	FLUIDSIM_CLEAR_FLUID,
	FLUIDSIM_CLEAR_SMOKE,
	FLUIDSIM_CLEAR_FUEL,
	FLUIDSIM_CLEAR_FIRE,
	FLUIDSIM_CLEAR_HEAT,
	FLUIDSIM_CLEAR_TEX,
	FLUIDSIM_CLEAR_COLOR,
	FLUIDSIM_KEEPSCALE,
	FLUIDSIM_AUTOITERATIONS,
	FLUIDSIM_MPEDITOR,
	FLUIDSIM_FIRE_SCENELIGHTS_SHADOW = 1356, 
		FLUIDSIM_FIRE_SCENELIGHTS_SHADOW_NONE = 0,
		FLUIDSIM_FIRE_SCENELIGHTS_SHADOW_SOFT,
		FLUIDSIM_FIRE_SCENELIGHTS_SHADOW_HARD,
		FLUIDSIM_FIRE_SCENELIGHTS_SHADOW_AREA,
	FLUIDSIM_FIRE_SCENELIGHTS_SHADOWDENSITY = 1357,
	FLUIDSIM_CACHE_SL,
	FLUIDSIM_CACHE_USECACHE_SL,
	FLUIDSIM_CACHE_USECACHE_RAM,
	FLUIDSIM_TMIX_FLUID,
	FLUIDSIM_OBSTACLE_FRCTQUALITY = 1362,
		FLUIDSIM_OBSTACLE_FRCTQUALITY_1 = 0,
		FLUIDSIM_OBSTACLE_FRCTQUALITY_2,
		FLUIDSIM_OBSTACLE_FRCTQUALITY_3,
		FLUIDSIM_OBSTACLE_FRCTQUALITY_4,
	FLUIDSIM_EXTRAPOLATION_LAYERS = 1363,
	FLUIDSIM_FLUIDPARTICLES_CHECKADVECT,
	FLUIDSIM_TMIX_BASEA = 1365,
		FLUIDSIM_TMIX_BASEA_SMOKE = 0,
		FLUIDSIM_TMIX_BASEA_HEAT,
		FLUIDSIM_TMIX_BASEA_FIRE,
		FLUIDSIM_TMIX_BASEA_FUEL,
	FLUIDSIM_TMIXB_FLUID = 1366,
	FLUIDSIM_C4DFORCE_GLOBALIMPACT,
	FLUIDSIM_C4DFORCE_ABSOLUTE,
	FLUIDSIM_VORTICITY_CHECKADVECT,
	FLUIDSIM_CACHE_SAVECACHE_COMPRESS,
	FLUIDSIM_SOLVERTYPE = 1371,
		FLUIDSIM_SOLVERTYPE_CG = 0,
		FLUIDSIM_SOLVERTYPE_GAUSS,
	FLUIDSIM_SPACEMODE = 1372,
		FLUIDSIM_SPACEMODE_SIMPLE = 0,
		FLUIDSIM_SPACEMODE_CDIM,
		FLUIDSIM_SPACEMODE_CDIMCELLS,
		FLUIDSIM_SPACEMODE_CELLSVSIZE,
	FLUIDSIM_VOXELDIM = 1373,
	FLUIDSIM_PRESETS = 1374,
		FLUIDSIM_PRESETS_DEFAULT = 0,
	FLUIDSIM_PRESETS_SET = 1375,
	FLUIDSIM_PRESETS_SAVE,
	FLUIDSIM_PRESETS_SAVEAS,
	FLUIDSIM_PRESETS_DE,
	FLUIDSIM_COOLINGPOINT,
	FLUIDSIM_HEATUPCURVE,
	FLUIDSIM_SIMPLEPARTICLES_MEDIA_USEAGE,
	FLUIDSIM_SIMPLEPARTICLES_MEDIA_AGE,
	FLUIDSIM_THINKINGPARTICLES_MEDIA_VAR,
	FLUIDSIM_THINKINGPARTICLES_WIND_USEAGE,
	FLUIDSIM_THINKINGPARTICLES_WIND_GRADIENT,
	FLUIDSIM_VORTICITY_AMP,
	FLUIDSIM_SUBDIVISION_ONLYLASTLAYER,
	FLUIDSIM_WATER_SIMTYPE = 1388,
		FLUIDSIM_WATER_SIMTYPE_PARTICLEGRID = 0,
		FLUIDSIM_WATER_SIMTYPE_PARTICLES,
		FLUIDSIM_WATER_SIMTYPE_PLS,
	FLUIDSIM_TRACEALGO_FLIP = 1389,
			FLUIDSIM_TRACEALGO_FLIP_EULER1ST = 0,
			FLUIDSIM_TRACEALGO_FLIP_RUNGA2ND,
			FLUIDSIM_TRACEALGO_FLIP_RUNGA3RD,
			FLUIDSIM_TRACEALGO_FLIP_RUNGA4TH,
	FLUIDSIM_SUBSTEPS_FLIP = 1390,
	FLUIDSIM_FLIPPARTICLES_CHECKADVECT,
	FLUIDSIM_COMBUSTION_TYPE = 1392,
		FLUIDSIM_COMBUSTION_TYPE_FUEL = 0,
		FLUIDSIM_COMBUSTION_TYPE_FUEL_OXYGEN,
	FLUIDSIM_OXYGEN = 1393,
	FLUIDSIM_VORTKERNEL_LENGTH,
	FLUIDSIM_VORTKERNEL_LENGTH_L1,
	FLUIDSIM_VORTKERNEL_LENGTH_L2,
	FLUIDSIM_VORTKERNEL_LENGTH_L3,
	FLUIDSIM_VORTKERNEL_LENGTH_L4,

	FLUIDSIM_FLUIDCACHE_SELECTFOLDER,
	FLUIDSIM_FLUIDCACHE_MODE = 1400,
		FLUIDSIM_FLUIDCACHE_MODE_OFF = 0,
		FLUIDSIM_FLUIDCACHE_MODE_FILE,
		FLUIDSIM_FLUIDCACHE_MODE_RAM,
	FLUIDSIM_FLUIDCACHE_STARTFRAME = 1401,
	FLUIDSIM_FLUIDCACHE_FILENAME,
	FLUIDSIM_FLUIDCACHE_FILENAME_NAME,
	FLUIDSIM_FLUIDCACHE_FRAME,
	FLUIDSIM_FLUIDCACHE_BLEND,

	FLUIDSIM_SMOKECACHE_SELECTFOLDER = 1409,
	FLUIDSIM_SMOKECACHE_MODE = 1410,
		FLUIDSIM_SMOKECACHE_MODE_OFF = 0,
		FLUIDSIM_SMOKECACHE_MODE_FILE,
		FLUIDSIM_SMOKECACHE_MODE_RAM,
	FLUIDSIM_SMOKECACHE_STARTFRAME = 1411,
	FLUIDSIM_SMOKECACHE_FILENAME,
	FLUIDSIM_SMOKECACHE_FILENAME_NAME,
	FLUIDSIM_SMOKECACHE_FRAME,
	FLUIDSIM_SMOKECACHE_BLEND,

	FLUIDSIM_TEMPCACHE_SELECTFOLDER = 1419,
	FLUIDSIM_TEMPCACHE_MODE = 1420,
		FLUIDSIM_TEMPCACHE_MODE_OFF = 0,
		FLUIDSIM_TEMPCACHE_MODE_FILE,
		FLUIDSIM_TEMPCACHE_MODE_RAM,
	FLUIDSIM_TEMPCACHE_STARTFRAME = 1421,
	FLUIDSIM_TEMPCACHE_FILENAME,
	FLUIDSIM_TEMPCACHE_FILENAME_NAME,
	FLUIDSIM_TEMPCACHE_FRAME,
	FLUIDSIM_TEMPCACHE_BLEND,

	FLUIDSIM_FUELCACHE_SELECTFOLDER = 1429,
	FLUIDSIM_FUELCACHE_MODE = 1430,
		FLUIDSIM_FUELCACHE_MODE_OFF = 0,
		FLUIDSIM_FUELCACHE_MODE_FILE,
		FLUIDSIM_FUELCACHE_MODE_RAM,
	FLUIDSIM_FUELCACHE_STARTFRAME = 1431,
	FLUIDSIM_FUELCACHE_FILENAME,
	FLUIDSIM_FUELCACHE_FILENAME_NAME,
	FLUIDSIM_FUELCACHE_FRAME,
	FLUIDSIM_FUELCACHE_BLEND,

	FLUIDSIM_FIRECACHE_SELECTFOLDER = 1439,
	FLUIDSIM_FIRECACHE_MODE = 1440,
		FLUIDSIM_FIRECACHE_MODE_OFF = 0,
		FLUIDSIM_FIRECACHE_MODE_FILE,
		FLUIDSIM_FIRECACHE_MODE_RAM,
	FLUIDSIM_FIRECACHE_STARTFRAME = 1441,
	FLUIDSIM_FIRECACHE_FILENAME,
	FLUIDSIM_FIRECACHE_FILENAME_NAME,
	FLUIDSIM_FIRECACHE_FRAME,
	FLUIDSIM_FIRECACHE_BLEND,

	FLUIDSIM_COLORCACHE_SELECTFOLDER = 1449,
	FLUIDSIM_COLORCACHE_MODE = 1450,
		FLUIDSIM_COLORCACHE_MODE_OFF = 0,
		FLUIDSIM_COLORCACHE_MODE_FILE,
		FLUIDSIM_COLORCACHE_MODE_RAM,
	FLUIDSIM_COLORCACHE_STARTFRAME = 1451,
	FLUIDSIM_COLORCACHE_FILENAME,
	FLUIDSIM_COLORCACHE_FILENAME_NAME,
	FLUIDSIM_COLORCACHE_FRAME,
	FLUIDSIM_COLORCACHE_BLEND,

	FLUIDSIM_FLOWMAPCACHE_SELECTFOLDER = 1459,
	FLUIDSIM_FLOWMAPCACHE_MODE = 1460,
		FLUIDSIM_FLOWMAPCACHE_MODE_OFF = 0,
		FLUIDSIM_FLOWMAPCACHE_MODE_FILE,
		FLUIDSIM_FLOWMAPCACHE_MODE_RAM,
	FLUIDSIM_FLOWMAPCACHE_STARTFRAME = 1461,
	FLUIDSIM_FLOWMAPCACHE_FILENAME,
	FLUIDSIM_FLOWMAPCACHE_FILENAME_NAME,
	FLUIDSIM_FLOWMAPCACHE_FRAME,
	FLUIDSIM_FLOWMAPCACHE_BLEND,

	FLUIDSIM_VORTICITY_DEPENDENCY = 1470,
		FLUIDSIM_VORTICITY_DEPENDENCY_OFF = 0,
		FLUIDSIM_VORTICITY_DEPENDENCY_MAGNITUDE,
		FLUIDSIM_VORTICITY_DEPENDENCY_SMOKE,
		FLUIDSIM_VORTICITY_DEPENDENCY_HEAT,
		FLUIDSIM_VORTICITY_DEPENDENCY_VORTICITY,
		FLUIDSIM_VORTICITY_DEPENDENCY_BDR_DISTANCE,
	FLUIDSIM_VORTICITY_DEPENDENCY_DENSITYLIMIT = 1471,
	FLUIDSIM_VORTICITY_DEPENDENCY_VORTICITYLIMIT,
	FLUIDSIM_VORTICITY_DEPENDENCY_DISTANCELIMIT,

	FLUIDSIM_VORTICITY_DEPENDENCY_L1 = 1474,
		FLUIDSIM_VORTICITY_DEPENDENCY_OFF_L1 = 0,
		FLUIDSIM_VORTICITY_DEPENDENCY_MAGNITUDE_L1,
		FLUIDSIM_VORTICITY_DEPENDENCY_SMOKE_L1,
		FLUIDSIM_VORTICITY_DEPENDENCY_HEAT_L1,
		FLUIDSIM_VORTICITY_DEPENDENCY_VORTICITY_L1,
		FLUIDSIM_VORTICITY_DEPENDENCY_BDR_DISTANCE_L1,
	FLUIDSIM_VORTICITY_DEPENDENCY_DENSITYLIMIT_L1 = 1475,
	FLUIDSIM_VORTICITY_DEPENDENCY_VORTICITYLIMIT_L1,
	FLUIDSIM_VORTICITY_DEPENDENCY_DISTANCELIMIT_L1,

	FLUIDSIM_VORTICITY_DEPENDENCY_L2 = 1478,
		FLUIDSIM_VORTICITY_DEPENDENCY_OFF_L2 = 0,
		FLUIDSIM_VORTICITY_DEPENDENCY_MAGNITUDE_L2,
		FLUIDSIM_VORTICITY_DEPENDENCY_SMOKE_L2,
		FLUIDSIM_VORTICITY_DEPENDENCY_HEAT_L2,
		FLUIDSIM_VORTICITY_DEPENDENCY_VORTICITY_L2,
		FLUIDSIM_VORTICITY_DEPENDENCY_BDR_DISTANCE_L2,
	FLUIDSIM_VORTICITY_DEPENDENCY_DENSITYLIMIT_L2 = 1479,
	FLUIDSIM_VORTICITY_DEPENDENCY_VORTICITYLIMIT_L2,
	FLUIDSIM_VORTICITY_DEPENDENCY_DISTANCELIMIT_L2,

	FLUIDSIM_VORTICITY_DEPENDENCY_L3 = 1482,
		FLUIDSIM_VORTICITY_DEPENDENCY_OFF_L3 = 0,
		FLUIDSIM_VORTICITY_DEPENDENCY_MAGNITUDE_L3,
		FLUIDSIM_VORTICITY_DEPENDENCY_SMOKE_L3,
		FLUIDSIM_VORTICITY_DEPENDENCY_HEAT_L3,
		FLUIDSIM_VORTICITY_DEPENDENCY_VORTICITY_L3,
		FLUIDSIM_VORTICITY_DEPENDENCY_BDR_DISTANCE_L3,
	FLUIDSIM_VORTICITY_DEPENDENCY_DENSITYLIMIT_L3 = 1483,
	FLUIDSIM_VORTICITY_DEPENDENCY_VORTICITYLIMIT_L3,
	FLUIDSIM_VORTICITY_DEPENDENCY_DISTANCELIMIT_L3,

	FLUIDSIM_VORTICITY_DEPENDENCY_L4 = 1486,
		FLUIDSIM_VORTICITY_DEPENDENCY_OFF_L4 = 0,
		FLUIDSIM_VORTICITY_DEPENDENCY_MAGNITUDE_L4,
		FLUIDSIM_VORTICITY_DEPENDENCY_SMOKE_L4,
		FLUIDSIM_VORTICITY_DEPENDENCY_HEAT_L4,
		FLUIDSIM_VORTICITY_DEPENDENCY_VORTICITY_L4,
		FLUIDSIM_VORTICITY_DEPENDENCY_BDR_DISTANCE_L4,
	FLUIDSIM_VORTICITY_DEPENDENCY_DENSITYLIMIT_L4 = 1487,
	FLUIDSIM_VORTICITY_DEPENDENCY_VORTICITYLIMIT_L4,
	FLUIDSIM_VORTICITY_DEPENDENCY_DISTANCELIMIT_L4,

	FLUIDSIM_CACHE_USECACHE_VP,
	FLUIDSIM_CACHE_VP,
	FLUIDSIM_CACHE_OFFSET,
	FLUIDSIM_CACHE_USECACHE_FL,
	FLUIDSIM_CACHE_USECACHE_MP,
	FLUIDSIM_CACHE_FL,
	FLUIDSIM_CACHE_MP,
	
	FLUIDSIM_TRACEALGO_FOAM = 1505,
		FLUIDSIM_TRACEALGO_FOAM_EULER1ST = 0,
		FLUIDSIM_TRACEALGO_FOAM_RUNGA2ND,
		FLUIDSIM_TRACEALGO_FOAM_RUNGA3RD,
		FLUIDSIM_TRACEALGO_FOAM_RUNGA4TH,
	FLUIDSIM_SUBSTEPS_FOAM = 1506,
	FLUIDSIM_FOAMPARTICLES_CHECKADVECT,
	
	FLUIDSIM_TRACEALGO_BUBBLE = 1513,
		FLUIDSIM_TRACEALGO_BUBBLE_EULER1ST = 0,
		FLUIDSIM_TRACEALGO_BUBBLE_RUNGA2ND,
		FLUIDSIM_TRACEALGO_BUBBLE_RUNGA3RD,
		FLUIDSIM_TRACEALGO_BUBBLE_RUNGA4TH,
	FLUIDSIM_SUBSTEPS_BUBBLE = 1514,
	FLUIDSIM_BUBBLEPARTICLES_CHECKADVECT,

	FLUIDSIM_CHANNEL_SPRAYPARTICLES,
	FLUIDSIM_CHANNEL_FOAMPARTICLES,
	FLUIDSIM_CHANNEL_BUBBLEPARTICLES,

	FLUIDSIM_DISPLAY_DRAWCONTAINER,
	FLUIDSIM_DISPLAY_DRAWGRIDTOP,
	FLUIDSIM_DISPLAY_DRAWGRIDBOTTOM,
	FLUIDSIM_DISPLAY_DRAWGRIDFRONT,
	FLUIDSIM_DISPLAY_DRAWGRIDBACK,
	FLUIDSIM_DISPLAY_DRAWVORTEXPARTICLES,
	FLUIDSIM_DISPLAY_DRAWFLUIDPARTICLES = 1525, 
		FLUIDSIM_DISPLAY_DRAWFLUIDPARTICLES_OFF = 0,
		FLUIDSIM_DISPLAY_DRAWFLUIDPARTICLES_ON,
		FLUIDSIM_DISPLAY_DRAWFLUIDPARTICLES_COLOR,
	FLUIDSIM_DISPLAY_DRAWLIQUIDPARTICLES = 1526,
		FLUIDSIM_DISPLAY_DRAWLIQUIDPARTICLES_OFF = 0,
		FLUIDSIM_DISPLAY_DRAWLIQUIDPARTICLES_ON,
		FLUIDSIM_DISPLAY_DRAWLIQUIDPARTICLES_ACC,
		FLUIDSIM_DISPLAY_DRAWLIQUIDPARTICLES_COLOR,
		FLUIDSIM_DISPLAY_DRAWLIQUIDPARTICLES_DENSITY,
		FLUIDSIM_DISPLAY_DRAWLIQUIDPARTICLES_VISCOSITY,
		FLUIDSIM_DISPLAY_DRAWLIQUIDPARTICLES_AGE,
		FLUIDSIM_DISPLAY_DRAWLIQUIDPARTICLES_CUSTOM,
	FLUIDSIM_DISPLAY_DRAWSPRAYPARTICLES = 1527,
	FLUIDSIM_DISPLAY_DRAWFOAMPARTICLES,
	FLUIDSIM_DISPLAY_DRAWBUBBLEPARTICLES,
	FLUIDSIM_DISPLAY_DRAWFLUIDMOTION,
	FLUIDSIM_DISPLAY_DRAWOBSTACLES,
	FLUIDSIM_WATER_FLIP_SUBTYPE = 1532,
			FLUIDSIM_WATER_FLIP_SUBTYPE_DEFAULT = 0,
			FLUIDSIM_WATER_FLIP_SUBTYPE_COLORED = 1,
			FLUIDSIM_WATER_FLIP_SUBTYPE_ADAPTIVE = 2,
	FLUIDSIM_ENCODE_COLORFLIP = 1533,
	FLUIDSIM_WATER_PICFLIP,
	FLUIDSIM_VELOCITYDAMPING,
	FLUIDSIM_VELOCITYDAMPING_ITERATION,
	FLUIDSIM_WATER_RELATIVEVISCOSITY,
	FLUIDSIM_ENCODE_VISCOSITY,
	FLUIDSIM_ENCODE_AGE,
	FLUIDSIM_ENCODE_DENSITY,
	FLUIDSIM_ENCODE_RADIUS,
	FLUIDSIM_GRIDCELLS_SUBDIVISION_EDITOR,
	FLUIDSIM_FLUIDCACHE_PARTICLES,
	FLUIDSIM_FLUIDCACHE_RENDERONLY,
	
	FLUIDSIM_FPCACHE_SELECTFOLDER,
	FLUIDSIM_FPCACHE_MODE = 1546, 
		FLUIDSIM_FPCACHE_MODE_OFF = 0,
		FLUIDSIM_FPCACHE_MODE_FILE,
	FLUIDSIM_FPCACHE_STARTFRAME = 1547,
	FLUIDSIM_FPCACHE_FILENAME,
	FLUIDSIM_FPCACHE_FILENAME_NAME,
	FLUIDSIM_FPCACHE_FRAME,
	
	FLUIDSIM_CACHE_FOAM,
	FLUIDSIM_CACHE_BUBBLES,
	FLUIDSIM_CACHE_USECACHE_FOAM,
	FLUIDSIM_CACHE_USECACHE_BUBBLES,
	FLUIDSIM_WATER_LEVELSET = 1555,
		FLUIDSIM_WATER_LEVELSET_SIMPLE = 0,
		FLUIDSIM_WATER_LEVELSET_SPHERE,
	FLUIDSIM_DISPLAY_VP_AMOUNT = 1556,
	FLUIDSIM_DISPLAY_FP_AMOUNT,
	FLUIDSIM_DISPLAY_FLIP_AMOUNT,
	FLUIDSIM_DISPLAY_FOAM_AMOUNT,
	
	FLUIDSIM_GMEMORY_FIELDLIQUID = 1560,
		FLUIDSIM_GMEMORY_FIELDLIQUID_WATER = 13,
		FLUIDSIM_GMEMORY_FIELDLIQUID_VISCOSITY = 15,
		FLUIDSIM_GMEMORY_FIELDLIQUID_HEAT = 4,

	FLUIDSIM_CACHE_USECACHE_LOADSAVE = 1561,
	FLUIDSIM_FIRE_SCENELIGHTS_LIFETIME,
	FLUIDSIM_CACHE_SAVEFRAME = 1563,
		FLUIDSIM_CACHE_SAVEFRAME_SIM = 0,
		FLUIDSIM_CACHE_SAVEFRAME_C4D,
	FLUIDSIM_BODYFORCES_ITERATIONS = 1564,
	FLUIDSIM_BODYFORCES_DIFFUSION,
	
	FLUIDSIM_FLUIDPARTICLES_EMITWATER,
	FLUIDSIM_SIMPLEPARTICLES_EMITWATER,
	FLUIDSIM_THINKINGPARTICLES_EMITWATER,
	FLUIDSIM_FLUIDPARTICLES_EMITWATER_SAMELOCATION,

	FLUIDSIM_DISPLAY_SLICE_AXIS = 1570,
		FLUIDSIM_DISPLAY_SLICE_AXIS_X = 0,
		FLUIDSIM_DISPLAY_SLICE_AXIS_Y,
		FLUIDSIM_DISPLAY_SLICE_AXIS_Z,
	FLUIDSIM_DISPLAY_SLICE_POS = 1571,
	FLUIDSIM_DISPLAY_SLICE_CHANNEL = 1572,
		FLUIDSIM_DISPLAY_SLICE_CHANNEL_OFF = 0,
		FLUIDSIM_DISPLAY_SLICE_CHANNEL_SMOKE,
		FLUIDSIM_DISPLAY_SLICE_CHANNEL_TEMPERATURE,
		FLUIDSIM_DISPLAY_SLICE_CHANNEL_FUEL,
		FLUIDSIM_DISPLAY_SLICE_CHANNEL_FIRE,
		FLUIDSIM_DISPLAY_SLICE_CHANNEL_COLOR,
		FLUIDSIM_DISPLAY_SLICE_CHANNEL_GRIDMEMORY,
		FLUIDSIM_DISPLAY_SLICE_CHANNEL_VORTICITY,
		FLUIDSIM_DISPLAY_SLICE_CHANNEL_PRESSURE,
		FLUIDSIM_DISPLAY_SLICE_CHANNEL_VISCOSITY,
		FLUIDSIM_DISPLAY_SLICE_CHANNEL_VDENSITY,
		FLUIDSIM_DISPLAY_SLICE_CHANNEL_SDF,
	FLUIDSIM_DISPLAY_SLICE_GRAD = 1573,
	FLUIDSIM_DISPLAY_DRAWGRIDLEFT,
	FLUIDSIM_DISPLAY_DRAWGRIDRIGHT,
	FLUIDSIM_DISPLAY_DRAWRENDERAREA,
	FLUIDSIM_MPRENDER,
	
	FLUIDSIM_WATER_FLIPMODE = 1578,
		FLUIDSIM_WATER_FLIPMODE_FLIP = 0,
		FLUIDSIM_WATER_FLIPMODE_HFAFLIP,

	FLUIDSIM_WATER_HFA_ZONEFACTOR = 1579,
	FLUIDSIM_WATER_HFA_THRESHOLD_VELOCITY,
	FLUIDSIM_WATER_HFA_THRESHOLD_PARTICLES,
	FLUIDSIM_WATER_HFA_THRESHOLD_ZONECELLS,

	FLUIDSIM_DUMMY_

};

#endif